/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.enchant;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.enchant.LOTREnchantmentSoulbound;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LOTREnchantBogachik {
    public static final LOTREnchantBogachik INSTANCE = new LOTREnchantBogachik();
    private static final Logger logger = LogManager.getLogger(LOTREnchantBogachik.class);
    private Map<String, List<ItemStack>> playerDroppedItems = new HashMap<String, List<ItemStack>>();

    @SubscribeEvent
    public void onLivingUpdateSoulbound(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            logger.debug("Player update: {}", new Object[]{player.getDisplayName()});
            if (player.field_70173_aa % 60 == 0) {
                logger.debug("Checking inventory for soulbound items...");
                for (ItemStack it : player.field_71071_by.field_70462_a) {
                    NBTTagCompound tag;
                    if (it == null || it.func_77978_p() == null || !LOTREnchantmentHelper.hasEnchant(it, LOTREnchantment.soulbound) || LOTREnchantmentSoulbound.getCooldown(tag = it.func_77978_p()) != null && !LOTREnchantmentSoulbound.getCooldown(tag).isNegative() && !LOTREnchantmentSoulbound.getCooldown(tag).isZero()) continue;
                    tag.func_74768_a("Saves", 1);
                    logger.debug("Updated 'Saves' tag for item: {}", new Object[]{it});
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDrops(PlayerDropsEvent event) {
        EntityPlayer player = event.entityPlayer;
        String playerName = player.getDisplayName();
        ArrayList<ItemStack> droppedItems = new ArrayList<ItemStack>();
        Iterator iterator = event.drops.iterator();
        logger.debug("Player {} drops items", new Object[]{playerName});
        while (iterator.hasNext()) {
            NBTTagCompound tag;
            EntityItem drop = (EntityItem)iterator.next();
            ItemStack stack = drop.func_92059_d();
            int level = 1;
            if (!LOTREnchantmentHelper.hasEnchant(stack, LOTREnchantment.soulbound) || level <= 0) continue;
            NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            if (!tag.func_74764_b("Saves")) {
                tag.func_74768_a("Saves", level - 1);
                iterator.remove();
                droppedItems.add(stack);
                logger.debug("Item with 'Saves' tag initialized: {}", new Object[]{stack});
            } else {
                int Saves;
                long CDMillis = tag.func_74763_f("CD");
                Instant CD = Instant.ofEpochMilli(CDMillis);
                if (CD.isBefore(Instant.now())) {
                    tag.func_74768_a("Saves", level);
                    tag.func_74772_a("CD", 0L);
                    logger.debug("Item cooldown expired, resetting 'Saves': {}", new Object[]{stack});
                }
                if ((Saves = tag.func_74762_e("Saves")) > 0) {
                    tag.func_74768_a("Saves", Saves - 1);
                    iterator.remove();
                    droppedItems.add(stack);
                    logger.debug("Item with 'Saves' tag decremented: {}", new Object[]{stack});
                }
            }
            stack.func_77982_d(tag);
        }
        if (!droppedItems.isEmpty()) {
            this.playerDroppedItems.put(playerName, droppedItems);
            logger.debug("Player {} dropped items recorded: {}", new Object[]{playerName, droppedItems});
        }
    }

    private long getCooldownForLevel() {
        return 3600L;
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        String playerName = player.getDisplayName();
        logger.debug("Player {} respawned", new Object[]{playerName});
        if (this.playerDroppedItems.containsKey(playerName)) {
            List<ItemStack> droppedItems = this.playerDroppedItems.get(playerName);
            Iterator<ItemStack> iterator = droppedItems.iterator();
            while (iterator.hasNext()) {
                ItemStack item = iterator.next();
                if (LOTREnchantmentHelper.hasEnchant(item, LOTREnchantment.soulbound)) {
                    NBTTagCompound tag;
                    Instant now = Instant.now();
                    NBTTagCompound nBTTagCompound = tag = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
                    if (tag.func_74764_b("Saves") && (now.toEpochMilli() > tag.func_74763_f("CD") || !tag.func_74764_b("CD") || tag.func_74763_f("CD") == 0L)) {
                        Instant CD = now.plusSeconds(this.getCooldownForLevel());
                        tag.func_74772_a("CD", CD.toEpochMilli());
                        logger.debug("Cooldown updated for item: {}", new Object[]{item});
                    }
                    item.func_77982_d(tag);
                    if (!player.field_71071_by.func_70441_a(item)) {
                        player.func_71019_a(item, false);
                        logger.debug("Item dropped on ground: {}", new Object[]{item});
                    }
                    iterator.remove();
                    continue;
                }
                logger.debug("Item {} does not have 'soulbound' enchantment, not respawning", new Object[]{item});
            }
            if (droppedItems.isEmpty()) {
                this.playerDroppedItems.remove(playerName);
                logger.debug("Player {}'s dropped items list cleared", new Object[]{playerName});
            }
        }
    }
}

